/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.dto.CtHolidayRequestDto;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;

public class CtHolidayRequestDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE 	= "CT_HOLIDAYREQUEST"	;
	public static final String KEY_1 	= "VOUCHER"				;	//xɐ\`[ԍ

	// 
	public static final String COL_VOUCHER				= "VOUCHER"			;	//xɐ\`[ԍ
	public static final String COL_WORKFLOW			= "WORKFLOW"		;	//[Nt[ԍ
	public static final String COL_K_CODE				= "KCODE"			;	//ЈR[h
	public static final String COL_REQUEST_DATE		= "REQUESTDATE"		;	//\
	public static final String COL_REASON				= "REASON"			;	//\R
	public static final String COL_SUBSTITUTE_DATE		= "SUBSTITUTEDATE"	;	//[
	public static final String COL_SUBSTITUTE_WORK		= "SUBSTITUTEWORK"	;	//[Ζ`
	public static final String COL_DELETE_FLAG			= "DELETEFLAG"		;	//폜tO

	/**
	 * RXgN^
	 */
	public CtHolidayRequestDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CtHolidayRequestDto> mappingAll() throws SQLException {
		List<CtHolidayRequestDto> all = new ArrayList<CtHolidayRequestDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return CtHolidayrequestDto ct_holidayrequestR[h
	 * @throws SQLException
	 */
	private CtHolidayRequestDto mapping() throws SQLException {
		CtHolidayRequestDto dto = new CtHolidayRequestDto();
		dto.setVoucher			(rs.getInt		(COL_VOUCHER)			);		//xɐ\`[ԍ
		dto.setWorkflow			(rs.getLong		(COL_WORKFLOW)			);		//[Nt[ԍ
		dto.setKCode			(rs.getString	(COL_K_CODE)			);		//ЈR[h
		dto.setRequestDate		(rs.getString	(COL_REQUEST_DATE)		);		//\
		dto.setReason			(rs.getString	(COL_REASON)			);		//\R
		dto.setSubstituteDate	(rs.getString	(COL_SUBSTITUTE_DATE)	);		//[
		dto.setSubstituteWork	(rs.getString	(COL_SUBSTITUTE_WORK)	);		//[Ζ`
		dto.setDeleteFlag		(rs.getInt		(COL_DELETE_FLAG)		);		//폜tO
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CtHolidayRequestDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CtHolidayRequestDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param voucher xɐ\`[ԍ(L[)
	 * @return CtHolidayrequestDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CtHolidayRequestDto findForKey(
			int     voucher
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, voucher);
			executeQuery();
			CtHolidayRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param voucher xɐ\`[ԍ(L[)
	 * @return CtHolidayrequestDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CtHolidayRequestDto findForUpdate(
			int voucher
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, voucher);
			executeQuery();
			CtHolidayRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param voucher xɐ\`[ԍ
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			int voucher
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_VOUCHER);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   voucher  );
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * @param kCode
	 * @return
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CtHolidayRequestDto> findForKCode(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = 0 ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   kCode  );
			executeQuery();
			List<CtHolidayRequestDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * @param workFlow
	 * @return
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CtHolidayRequestDto findForWorkFlow(
			long     workFlow
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_WORKFLOW);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, workFlow);
			executeQuery();
			CtHolidayRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * maxl擾
	 * @return String@őA
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public String findForMax() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String maxEno = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_VOUCHER);
			sb.append(") FROM ");
			sb.append(TABLE);
			prepareStatement(sb.toString());
			executeQuery();
			if (rs.next()) {
				maxEno = String.valueOf(rs.getInt(1));
			}
			return maxEno;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CtHolidayRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CtHolidayRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getVoucher());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CtHolidayRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getVoucher());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(CtHolidayRequestDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getVoucher());		//xɐ\`[ԍ
		setParam(index++, dto.getWorkflow());		//[Nt[ԍ
		setParam(index++, dto.getKCode());			//ЈR[h
		setParam(index++, dto.getRequestDate());	//\
		setParam(index++, dto.getReason());			//\R
		setParam(index++, dto.getSubstituteDate());	//[
		setParam(index++, dto.getSubstituteWork());	//[Ζ`
		setParam(index++, dto.getDeleteFlag());		//폜tO
		setCommonParams(isInsert);
	}

}
